// // app/ncert-course/page.tsx
// // NCERT Economy for UPSC — Page built to match your Nankinomics home-page styling (white bg, blue CTAs, clean cards).

// import Link from "next/link"
// import Image from "next/image"
// import Header from "@/components/header_2";
// import Footer from "@/components/footer_2";

// // If you already have these components, uncomment and use them:
// // import Header from "@/components/Header"
// // import Footer from "@/components/Footer"

// const PRIMARY_BLUE = "bg-blue-600 hover:bg-blue-700"
// const PRIMARY_BLUE_TEXT = "text-blue-600 hover:text-blue-700"

// export default function NcertCoursePage() {
//   return (
//     <>
//       {/* If you have a global header on layout, remove this */}
//       {/* <Header /> */}

//       <main className="bg-white">
//         <Header />
//         <HeroSection />
//         <WhyNcertMattersSection />
//         <HowWeCoverNcertSection />

//         {/* ✅ Option A: Downloads section between Section 3 and Section 4 */}


//         <WorksheetsPackSection />
//         <NcertBooksDownloadSection />
//         <Section6_FAQs_ncert/>
//         <Footer/>
//       </main>

//       {/* If you have a global footer on layout, remove this */}
//       {/* <Footer /> */}
//     </>
//   )
// }

// /* -------------------------------------------
//    SECTION 1 — HERO (FIRST FOLD)
//    Content locked — do not modify
// -------------------------------------------- */

// function HeroSection() {
//   return (
//     <section className="bg-white">
//       <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
//         {/* Desktop: spacious top/bottom; Mobile: tighter */}
//         <div className="flex flex-col lg:flex-row items-center gap-10 lg:gap-16 pt-12 pb-12 lg:pt-28 lg:pb-20">
//           {/* Left: Text */}
//           <div className="w-full lg:w-7/12 order-2 lg:order-1">
//             <h1 className="text-4xl sm:text-5xl font-semibold text-[#1A1A1A] max-w-2xl">
//               NCERT Economy for UPSC
//             </h1>

//             <p className="mt-4 text-lg sm:text-xl font-normal text-[#4A4A4A] max-w-2xl leading-relaxed">
//               Build strong fundamentals in Economics using Class 9–12 NCERTs — without
//               information overload.
//             </p>

//             <p className="mt-3 text-base sm:text-lg text-[#4B5563] max-w-2xl leading-relaxed">
//               Free NCERT lectures on YouTube + structured worksheets & practice MCQs to
//               complete your NCERT preparation.
//             </p>

//             {/* CTAs (primary visible without scrolling) */}
//             <div className="mt-6 flex flex-col sm:flex-row gap-3 sm:gap-4">
//               <Link
//                 href="/pay/ncert-pack" // TODO: update to your actual checkout route
//                 className={`inline-flex items-center justify-center px-6 py-3.5 rounded-lg text-sm sm:text-base font-semibold text-white ${PRIMARY_BLUE} transition-colors`}
//               >
//                 Get NCERT Economy Worksheets &amp; Practice Pack (₹199)
//               </Link>

//               <Link
//                 href="https://youtube.com/playlist?list=PLew2VWuM9WHZh7_23_pzIjC-7IV0vPhwB&si=Fa7tKG8773-97PYd" // TODO: update to actual YouTube / playlist page
//                 className={`inline-flex items-center justify-center px-5 py-3 rounded-lg text-sm sm:text-base font-semibold border-2 border-blue-600 ${PRIMARY_BLUE_TEXT} transition-colors`}
//               >
//                 Watch Free NCERT Economy Lectures on YouTube
//               </Link>
//             </div>
//           </div>

//           {/* Right: Clean static visual (placeholder) */}
//           <div className="w-full lg:w-5/12 order-1 lg:order-2 flex justify-center lg:justify-end">
//             <div className="relative w-full max-w-sm mx-auto lg:mr-2">
//               <div className="relative h-[360px] sm:h-[420px] lg:h-[460px] rounded-2xl bg-white shadow-[0_10px_25px_rgba(0,0,0,0.12)] overflow-hidden border border-gray-100">
//                 {/* TODO: replace with your illustration (NCERT books/notes/worksheets) */}
//                 <Image
//                   src="/course_image.avif"
//                   alt="NCERT books, notes and worksheets illustration"
//                   fill
//                   className="object-cover"
//                   priority
//                 />
//               </div>
//             </div>
//           </div>
//         </div>
//       </div>
//     </section>
//   )
// }

// /* -------------------------------------------
//    SECTION 2 — WHY NCERTs MATTER FOR UPSC ECONOMY
//    3 short blocks/cards (icon + 1–2 lines)
// -------------------------------------------- */

// function WhyNcertMattersSection() {
//   const blocks = [
//     {
//       title: "Strong conceptual base for all Economy questions",
//       icon: <ConceptIcon />,
//     },
//     {
//       title: "Around 25–30% Prelims questions can be handled with solid NCERT understanding",
//       icon: <ExamIcon />,
//     },
//     {
//       title: "NCERTs make Budget, Economic Survey & current affairs easier to understand",
//       icon: <ApplicationIcon />,
//     },
//   ]

//   return (
//     <section className="bg-white py-14 sm:py-16">
//       <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
//         <div className="text-center max-w-3xl mx-auto">
//           <h2 className="text-3xl sm:text-4xl font-semibold text-[#111827]">
//             Why NCERTs Matter for UPSC Economy
//           </h2>
//         </div>

//         <div className="mt-10 grid grid-cols-1 md:grid-cols-3 gap-6 lg:gap-8">
//           {blocks.map((b, idx) => (
//             <div
//               key={idx}
//               className="h-full bg-white rounded-2xl border border-gray-200 shadow-[0_10px_30px_rgba(0,0,0,0.06)] p-7 sm:p-8"
//             >
//               <div className="flex items-start gap-4">
//                 <div className="shrink-0">{b.icon}</div>
//                 <p className="text-[15px] sm:text-[16px] leading-relaxed text-[#111827] font-medium">
//                   {b.title}
//                 </p>
//               </div>
//             </div>
//           ))}
//         </div>
//       </div>
//     </section>
//   )
// }

// /* -------------------------------------------
//    SECTION 3 — HOW WE COVER NCERT ECONOMY
//    Step-by-step horizontal flow/journey
// -------------------------------------------- */

// function HowWeCoverNcertSection() {
//   const steps = [
//     {
//       num: "1",
//       title: "Watch",
//       desc: "Free NCERT Economy lectures on YouTube (Class 9–12)",
//     },
//     {
//       num: "2",
//       title: "Capture",
//       desc: "Key ideas through guided NCERT worksheets",
//     },
//     {
//       num: "3",
//       title: "Revise & Check",
//       desc: "Reinforce concepts using NCERT-based MCQs",
//     },
//   ]

//   return (
//     <section className="bg-white py-14 sm:py-16">
//       <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
//         <div className="text-center max-w-3xl mx-auto">
//           <h2 className="text-3xl sm:text-4xl font-semibold text-[#111827]">
//             How We Cover NCERT Economy
//           </h2>
//         </div>

//         {/* Flow: stacked on mobile, horizontal on desktop */}
//         <div className="mt-10">
//           <div className="grid grid-cols-1 md:grid-cols-3 gap-6 lg:gap-8">
//             {steps.map((s) => (
//               <div
//                 key={s.num}
//                 className="h-full bg-white rounded-2xl border border-gray-200 shadow-[0_10px_30px_rgba(0,0,0,0.06)] p-7 sm:p-8"
//               >
//                 <div className="flex items-start gap-4">
//                   <div className="shrink-0">
//                     <div className="h-10 w-10 rounded-full bg-blue-600 text-white flex items-center justify-center font-semibold shadow-sm">
//                       {s.num}
//                     </div>
//                   </div>
//                   <div>
//                     <h3 className="text-xl sm:text-2xl font-semibold text-[#111827]">
//                       {s.title}
//                     </h3>
//                     <p className="mt-2 text-[15px] sm:text-[16px] leading-relaxed text-[#4B5563]">
//                       {s.desc}
//                     </p>
//                   </div>
//                 </div>
//               </div>
//             ))}
//           </div>

//           {/* calm reassurance line (no pricing/CTA here) */}
//           <p className="mt-6 text-center text-sm sm:text-base text-[#6B7280]">
//             A methodical, calm journey — so you always know what to do next.
//           </p>
//         </div>
//       </div>
//     </section>
//   )
// }

// /* -------------------------------------------
//    OPTION A ADD-ON — NCERT BOOK DOWNLOADS
//    Placeholder data; user will replace with real inputs
// -------------------------------------------- */

// type NcertBook = {
//   id: string
//   title: string
//   subtitle?: string
//   coverSrc: string
//   downloadHref: string
// }

// const DUMMY_BOOKS: NcertBook[] = [
//   {
//     id: "c9-econ",
//     title: "NCERT Economics — Class 9",
//     subtitle: "Dummy Book Title",
//     coverSrc: "/class_9_economics.jpg",
//     downloadHref: "https://ncert.nic.in/textbook/pdf/iess2dd.zip",
//   },
//   {
//     id: "c10-econ",
//     title: "NCERT Economics — Class 10",
//     subtitle: "Understanding Economic Development",
//     coverSrc: "/class_10_economics.jpg",
//     downloadHref: "https://ncert.nic.in/textbook/pdf/jess2dd.zip",
//   },
//   {
//     id: "c11-ied",
//     title: "NCERT Economics — Class 11",
//     subtitle: "Indian Economic Development",
//     coverSrc: "/class_11_economics_1.jpg",
//     downloadHref: "https://ncert.nic.in/textbook/pdf/keec1dd.zip",
//   },
//   {
//     id: "c11-ied2",
//     title: "NCERT Economics — Class 11",
//     subtitle: "Statistics for Economics",
//     coverSrc: "/class_11_economics_2.jpg",
//     downloadHref: "https://ncert.nic.in/textbook/pdf/kest1dd.zip",
//   },
//   {
//     id: "c12-micro",
//     title: "NCERT Economics — Class 12",
//     subtitle: "Introduction to Microeconomics",
//     coverSrc: "/class_12_economics_1.jpg",
//     downloadHref: "https://ncert.nic.in/textbook/pdf/leec2dd.zip",
//   },
//   {
//     id: "c12-macro2",
//     title: "NCERT Economics — Class 12",
//     subtitle: "Introduction to Macroeconomics",
//     coverSrc: "/class_12_economics_2.jpg",
//     downloadHref: "https://ncert.nic.in/textbook/pdf/leec1dd.zip",
//   },
// ]

// function NcertBooksDownloadSection() {
//   const books = DUMMY_BOOKS // ✅ Replace this array with your real book inputs

//   return (
//     <section id="ncert-downloads" className="bg-white py-14 sm:py-16 scroll-mt-24">
//       <div className="max-w-7xl mx-auto px-5 sm:px-6 lg:px-8">
//         <div className="text-center max-w-3xl mx-auto">
//           <h2 className="text-3xl sm:text-4xl font-semibold text-[#111827]">
//             Download NCERT Economics Books (Class 9–12)
//           </h2>
//           <p className="mt-3 sm:mt-4 text-base sm:text-lg text-[#4B5563] leading-relaxed">
//             Grab the books directly from here — and use them alongside the course so
//             your reading stays structured and exam-focused.
//           </p>
//         </div>

//         {/* Horizontal strip (desktop + mobile) */}
//         <div className="mt-10 sm:mt-12 -mx-5 px-5 overflow-x-auto">
//           <div className="flex gap-5 sm:gap-6">
//             {books.map((b) => (
//               <div key={b.id} className="flex-shrink-0 w-52 sm:w-56">
//                 <div className="h-full bg-white rounded-2xl border border-gray-200 shadow-[0_10px_30px_rgba(0,0,0,0.06)] overflow-hidden flex flex-col">
//                   <div className="relative w-full aspect-[3/4] bg-[#F9FAFB]">
//                     <Image
//                       src={b.coverSrc}
//                       alt={b.title}
//                       fill
//                       className="object-cover"
//                       sizes="(max-width: 640px) 208px, 224px"
//                     />
//                   </div>

//                   <div className="p-4 flex flex-col gap-2 flex-1">
//                     <div>
//                       <p className="text-[15px] sm:text-base font-semibold text-[#111827] leading-snug line-clamp-2">
//                         {b.title}
//                       </p>
//                       {b.subtitle && (
//                         <p className="mt-1 text-sm text-[#6B7280] leading-snug line-clamp-2">
//                           {b.subtitle}
//                         </p>
//                       )}
//                     </div>

//                     <div className="mt-auto pt-2">
//                       <a
//                         href={b.downloadHref}
//                         target={b.downloadHref.startsWith("http") ? "_blank" : undefined}
//                         rel={
//                           b.downloadHref.startsWith("http")
//                             ? "noopener noreferrer"
//                             : undefined
//                         }
//                         className="inline-flex items-center justify-center w-full px-4 py-2.5 rounded-full text-sm font-semibold bg-blue-600 hover:bg-blue-700 text-white transition-colors group"
//                       >
//                         Download
//                         <span className="ml-2 transition-transform duration-200 group-hover:translate-x-1">
//                           →
//                         </span>
//                       </a>
//                     </div>
//                   </div>
//                 </div>
//               </div>
//             ))}
//           </div>
//         </div>

//         <div className="mt-6 text-center text-sm text-[#6B7280]">
//           Tip: On mobile, swipe to view all books.
//         </div>
//       </div>
//     </section>
//   )
// }

// /* -------------------------------------------
//    SECTION 4 — NCERT ECONOMY WORKSHEETS & PRACTICE PACK
//    Content locked — do not modify
// -------------------------------------------- */

// function WorksheetsPackSection() {
//   return (
//     <section className="bg-white py-16 sm:py-20">
//       <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
//         <div className="flex flex-col lg:flex-row items-start gap-10 lg:gap-16">
//           {/* Left: Text */}
//           <div className="w-full lg:w-7/12">
//             <h2 className="text-3xl sm:text-4xl font-semibold text-[#111827]">
//               NCERT Economy Worksheets &amp; Practice Pack
//             </h2>

//             <p className="mt-4 text-base sm:text-lg text-[#4B5563] leading-relaxed max-w-2xl">
//               This pack helps you work through NCERT Economics actively, instead of just
//               reading or watching videos.
//             </p>

//             <p className="mt-2 text-base sm:text-lg text-[#4B5563] leading-relaxed max-w-2xl">
//               It is meant to convert:
//             </p>

//             <ul className="mt-3 space-y-2 text-[15px] sm:text-[16px] text-[#374151]">
//               <li className="flex gap-2">
//                 <span className="mt-[6px] text-sm">•</span>
//                 <span>NCERT reading</span>
//               </li>
//               <li className="flex gap-2">
//                 <span className="mt-[6px] text-sm">•</span>
//                 <span>YouTube explanations</span>
//               </li>
//             </ul>

//             <p className="mt-3 text-base sm:text-lg text-[#4B5563] leading-relaxed max-w-2xl">
//               into written understanding and tested clarity.
//             </p>


//             <div className="mt-8">
//               <h3 className="text-lg sm:text-xl font-semibold text-[#111827]">
//                 What this pack helps you do
//               </h3>
//               <ul className="mt-4 space-y-2 text-[15px] sm:text-[16px] text-[#374151]">
//                 <li className="flex gap-2">
//                   <span className="mt-[6px] text-sm">•</span>
//                   <span>Work through NCERT chapters using structured worksheets</span>
//                 </li>
//                 <li className="flex gap-2">
//                   <span className="mt-[6px] text-sm">•</span>
//                   <span>Revise NCERT Economics systematically</span>
//                 </li>
//                 <li className="flex gap-2">
//                   <span className="mt-[6px] text-sm">•</span>
//                   <span>Check your understanding using NCERT-based MCQs</span>
//                 </li>
//               </ul>
//             </div>

//             <div className="mt-8">
//               <h3 className="text-lg sm:text-xl font-semibold text-[#111827]">
//                 What you get
//               </h3>
//               <ul className="mt-4 space-y-2 text-[15px] sm:text-[16px] text-[#374151]">
//                 <li className="flex gap-2">
//                   <span className="mt-[6px] text-sm">•</span>
//                   <span>
//                     <span className="font-semibold">NCERT Economy Worksheets</span>{" "}
//                     (chapter-wise, guided, aligned with Class 9–12 NCERTs)
//                   </span>
//                 </li>
//                 <li className="flex gap-2">
//                   <span className="mt-[6px] text-sm">•</span>
//                   <span>
//                     <span className="font-semibold">200+ NCERT-based MCQs</span>{" "}
//                     (Level 1 and Level 2)
//                   </span>
//                 </li>
//               </ul>
//             </div>

//             <p className="mt-6 text-base sm:text-lg text-[#4B5563] leading-relaxed max-w-2xl">
//               Once you complete the worksheets and MCQs, NCERT Economics is no longer a
//               loose or half-done part of your preparation.
//             </p>

//             <p className="mt-6 text-lg sm:text-xl font-semibold text-[#111827]">
//               ₹199 — one-time access
//             </p>

//             <div className="mt-6">
//               <Link
//                 href="/pay/ncert-pack" // TODO: update to actual purchase route
//                 className={`inline-flex items-center justify-center px-7 py-3.5 rounded-lg text-sm sm:text-base font-semibold text-white ${PRIMARY_BLUE} transition-colors w-full sm:w-auto sm:min-w-[320px]`}
//               >
//                 Get NCERT Economy Worksheets &amp; Practice Pack
//               </Link>
//             </div>
//           </div>

//           {/* Right: Visual emphasis area */}
//           <div className="w-full lg:w-5/12">
//             <div className="bg-white rounded-2xl border border-gray-200 shadow-[0_10px_30px_rgba(0,0,0,0.06)] p-7 sm:p-8">
//               <p className="text-sm font-semibold text-[#111827]">
//                 Worksheets
//               </p>

//               <div className="mt-4 rounded-xl bg-[#F9FAFB] border border-gray-100 overflow-hidden">
//                 <Image
//                     src="/Nankinomics- Notes cum worksheet 1 (1)-1.png" // TODO: replace with your image
//                     alt="NCERT Economy Worksheets Preview"
//                     width={600}
//                     height={360}
//                     className="w-full h-auto object-cover"
//                 />
//               </div>


//               <p className="mt-6 text-sm font-semibold text-[#111827]">MCQs</p>
//               <div className="mt-4 rounded-xl bg-[#F9FAFB] border border-gray-100 overflow-hidden">
//                 <Image
//                     src="/mcq_pic.jpg" // TODO: replace with your image
//                     alt="NCERT Economy Worksheets Preview"
//                     width={600}
//                     height={360}
//                     className="w-full h-auto object-cover"
//                 />
//               </div>



//             </div>
//           </div>
//         </div>
//       </div>
//     </section>
//   )
// }

// /* -------------------------------------------
//    Small inline icons for Section 2 (simple + clean)
// -------------------------------------------- */

// function ConceptIcon() {
//   return (
//     <div className="h-12 w-12 rounded-2xl bg-blue-50 flex items-center justify-center border border-blue-100">
//       <svg viewBox="0 0 24 24" className="h-6 w-6 text-blue-600" fill="none" stroke="currentColor" strokeWidth="2">
//         <path d="M12 3l9 5-9 5-9-5 9-5Z" />
//         <path d="M3 8v8l9 5 9-5V8" />
//       </svg>
//     </div>
//   )
// }

// function ExamIcon() {
//   return (
//     <div className="h-12 w-12 rounded-2xl bg-blue-50 flex items-center justify-center border border-blue-100">
//       <svg viewBox="0 0 24 24" className="h-6 w-6 text-blue-600" fill="none" stroke="currentColor" strokeWidth="2">
//         <path d="M7 3h10a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2Z" />
//         <path d="M9 8h6M9 12h6M9 16h4" />
//       </svg>
//     </div>
//   )
// }

// function ApplicationIcon() {
//   return (
//     <div className="h-12 w-12 rounded-2xl bg-blue-50 flex items-center justify-center border border-blue-100">
//       <svg viewBox="0 0 24 24" className="h-6 w-6 text-blue-600" fill="none" stroke="currentColor" strokeWidth="2">
//         <path d="M4 19V5a2 2 0 0 1 2-2h9l5 5v11a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2Z" />
//         <path d="M14 3v5h5" />
//         <path d="M8 14h8M8 17h6" />
//       </svg>
//     </div>
//   )
// }


// function Section6_FAQs_ncert() {
//   type FAQItem = {
//     question: string;
//     answer: React.ReactNode;
//   };

//   const FAQ_ITEMS: FAQItem[] = [
//     {
//       question: "Who is this NCERT Economics course meant for?",
//       answer: (
//         <>
//           This course is for anyone who wants to understand Economics from the
//           basics before jumping into heavier UPSC material. It’s ideal for
//           beginners, college students, self-study learners, aspirants who find
//           Economy difficult, and those who feel overwhelmed in long 120–160 hour
//           Foundation courses. It acts as a bridge between starting from zero and
//           studying advanced content confidently.
//         </>
//       ),
//     },
//     {
//       question:
//         "Do I need to finish all five NCERTs (Class 9–12, including Class 12 Micro & Macro)?",
//       answer: (
//         <>
//           No. You don’t need to complete all five books end-to-end. Almost every
//           NCERT chapter has something relevant, but not all carry equal weight.
//           This course shows what to read fully, what to read selectively, and what
//           can be skimmed, so you study what matters — not everything blindly.
//         </>
//       ),
//     },
//     {
//       question: "Is NCERT enough for UPSC Economics?",
//       answer: (
//         <>
//           NCERT builds your fundamentals, but for UPSC you will still need current
//           affairs, Economic Survey & Budget, and applied understanding of policies
//           and data. This course ensures your basics become strong, so advanced
//           sources become easier and far more meaningful.
//         </>
//       ),
//     },
//     {
//       question: "How long does this course take to finish?",
//       answer: (
//         <>
//           The complete video set is about 20 hours. Most learners finish it in
//           7–10 days, while some take 2–3 weeks depending on their pace.
//         </>
//       ),
//     },
//     {
//       question: "What language is the course in?",
//       answer: (
//         <>
//           Videos are in Hinglish — mainly English with simple Hindi explanations
//           where needed. Worksheets are in English.
//         </>
//       ),
//     },
//     {
//       question: "What teaching method do you follow?",
//       answer: (
//         <div className="space-y-2">
//           <p>A simple 3-step system:</p>
//           <ul className="list-disc pl-5 space-y-1">
//             <li>Watch → short conceptual videos</li>
//             <li>Write → guided worksheets</li>
//             <li>Practice → MCQs and short tests</li>
//           </ul>
//           <p>
//             This helps you understand and retain concepts, not just cover the
//             books.
//           </p>
//         </div>
//       ),
//     },
//     {
//       question: "What do I get with the Full Access Plan (₹199)?",
//       answer: (
//         <div className="space-y-2">
//           <p>You receive the complete NCERT toolkit:</p>
//           <ul className="list-disc pl-5 space-y-1">
//             <li>Worksheets (delivered via email)</li>
//             <li>200 NCERT-based MCQs</li>
//             <li>2 Doubt-Clearing Sessions</li>
//             <li>Private Telegram Community access</li>
//           </ul>
//         </div>
//       ),
//     },
//     {
//       question:
//         "Why should I buy the paid plan when videos are free on YouTube?",
//       answer: (
//         <>
//           Videos explain the concepts. The paid plan gives you the full system:
//           worksheets (active recall), MCQs (testing), doubt support, and a
//           structured learning path that makes your preparation exam-ready.
//         </>
//       ),
//     },
//     {
//       question: "I’m starting preparation late. Will this still help me?",
//       answer: (
//         <>
//           Yes. This is a high-ROI, low-time foundation course. You can finish your
//           NCERT basics in 20 hours and build confidence quickly.
//         </>
//       ),
//     },
//   ];
//   return (
//     <section className="bg-white py-16 sm:py-20 border-t border-gray-100">
//       <div className="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
//         <h2 className="text-3xl sm:text-4xl font-semibold text-[#111827] text-center">
//           FAQs — NCERT Economy course
//         </h2>

//         <div className="mt-10 space-y-4">
//           {FAQ_ITEMS.map((f, i) => (
//             <details
//               key={i}
//               className="group bg-white rounded-2xl border border-gray-200 shadow-[0_10px_30px_rgba(0,0,0,0.06)] p-6 sm:p-7"
//             >
//               <summary className="cursor-pointer list-none flex items-start justify-between gap-4">
//                 <span className="text-[15px] sm:text-[16px] font-semibold text-[#111827] leading-relaxed">
//                   {f.question}
//                 </span>
//                 <span className="mt-1 text-[#6B7280] transition-transform duration-200 group-open:rotate-180">
//                   ▾
//                 </span>
//               </summary>

//               <div className="mt-4 text-[15px] sm:text-[16px] text-[#4B5563] leading-relaxed">
//                 {f.answer}
//               </div>

//             </details>
//           ))}
//         </div>

//         {/* No extra CTAs required by spec; keeping it clean */}
//       </div>
//     </section>
//   )
// }




// app/ncert-course/page.tsx
// NCERT Economy for UPSC — Page built to match your Nankinomics home-page styling (white bg, blue CTAs, clean cards).

import Link from "next/link"
import Image from "next/image"
import Header from "@/components/header_2";
import Footer from "@/components/footer_2";

// If you already have these components, uncomment and use them:
// import Header from "@/components/Header"
// import Footer from "@/components/Footer"

const PRIMARY_BLUE = "bg-blue-600 hover:bg-blue-700"
const PRIMARY_BLUE_TEXT = "text-blue-600 hover:text-blue-700"

// ✅ Stronger, visible hover animation (works reliably)
const HOVER_ANIM =
  "inline-flex transform-gpu transition-all duration-200 ease-out hover:-translate-y-0.5 hover:scale-[1.02] hover:shadow-md active:translate-y-0 active:scale-[0.99] focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-blue-500 focus-visible:ring-offset-2"

export default function NcertCoursePage() {
  return (
    <>
      {/* If you have a global header on layout, remove this */}
      {/* <Header /> */}

      <main className="bg-white">
        <Header />
        <HeroSection />
        <WhyNcertMattersSection />
        <HowWeCoverNcertSection />

        {/* ✅ Option A: Downloads section between Section 3 and Section 4 */}

        <WorksheetsPackSection />
        <NcertBooksDownloadSection />
        <Section6_FAQs_ncert/>
        <Footer/>
      </main>

      {/* If you have a global footer on layout, remove this */}
      {/* <Footer /> */}
    </>
  )
}

/* -------------------------------------------
   SECTION 1 — HERO (FIRST FOLD)
   Content locked — do not modify
-------------------------------------------- */

function HeroSection() {
  return (
    <section className="bg-white">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Desktop: spacious top/bottom; Mobile: tighter */}
        <div className="flex flex-col lg:flex-row items-center gap-10 lg:gap-16 pt-12 pb-12 lg:pt-28 lg:pb-20">
          {/* Left: Text */}
          <div className="w-full lg:w-7/12 order-2 lg:order-1">
            <h1 className="text-4xl sm:text-5xl font-semibold text-[#1A1A1A] max-w-2xl">
              NCERT Economy for UPSC
            </h1>

            <p className="mt-4 text-lg sm:text-xl font-normal text-[#4A4A4A] max-w-2xl leading-relaxed">
              Build strong fundamentals in Economics using Class 9–12 NCERTs — without
              information overload.
            </p>

            <p className="mt-3 text-base sm:text-lg text-[#4B5563] max-w-2xl leading-relaxed">
              Free NCERT lectures on YouTube + structured worksheets & practice MCQs to
              complete your NCERT preparation.
            </p>

            {/* CTAs (primary visible without scrolling) */}
            <div className="mt-6 flex flex-col sm:flex-row gap-3 sm:gap-4">
              <Link
                href="/go?sku=worksheet_01" // TODO: update to your actual checkout route
                className={`items-center justify-center px-6 py-3.5 rounded-lg text-sm sm:text-base font-semibold text-white ${PRIMARY_BLUE} transition-colors ${HOVER_ANIM}`}
              >
                Get NCERT Economy Worksheets &amp; Practice Pack (₹199)
              </Link>

              <Link
                href="https://youtube.com/playlist?list=PLew2VWuM9WHZh7_23_pzIjC-7IV0vPhwB&si=Fa7tKG8773-97PYd" // TODO: update to actual YouTube / playlist page
                className={`items-center justify-center px-5 py-3 rounded-lg text-sm sm:text-base font-semibold border-2 border-blue-600 ${PRIMARY_BLUE_TEXT} transition-colors ${HOVER_ANIM}`}
              >
                Watch Free NCERT Economy Lectures on YouTube
              </Link>
            </div>
          </div>

          {/* Right: Clean static visual (placeholder) */}
          <div className="w-full lg:w-5/12 order-1 lg:order-2 flex justify-center lg:justify-end">
            <div className="relative w-full max-w-sm mx-auto lg:mr-2">
              <div className="relative h-[360px] sm:h-[420px] lg:h-[460px] rounded-2xl bg-white shadow-[0_10px_25px_rgba(0,0,0,0.12)] overflow-hidden border border-gray-100">
                {/* TODO: replace with your illustration (NCERT books/notes/worksheets) */}
                <Image
                  src="/course_image.avif"
                  alt="NCERT books, notes and worksheets illustration"
                  fill
                  className="object-cover"
                  priority
                />
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}

/* -------------------------------------------
   SECTION 2 — WHY NCERTs MATTER FOR UPSC ECONOMY
   3 short blocks/cards (icon + 1–2 lines)
-------------------------------------------- */

function WhyNcertMattersSection() {
  const blocks = [
    {
      title: "Strong conceptual base for all Economy questions",
      icon: <ConceptIcon />,
    },
    {
      title: "Around 25–30% Prelims questions can be handled with solid NCERT understanding",
      icon: <ExamIcon />,
    },
    {
      title: "NCERTs make Budget, Economic Survey & current affairs easier to understand",
      icon: <ApplicationIcon />,
    },
  ]

  return (
    <section className="bg-white py-14 sm:py-16">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center max-w-3xl mx-auto">
          <h2 className="text-3xl sm:text-4xl font-semibold text-[#111827]">
            Why NCERTs Matter for UPSC Economy
          </h2>
        </div>

        <div className="mt-10 grid grid-cols-1 md:grid-cols-3 gap-6 lg:gap-8">
          {blocks.map((b, idx) => (
            <div
              key={idx}
              className="h-full bg-white rounded-2xl border border-gray-200 shadow-[0_10px_30px_rgba(0,0,0,0.06)] p-7 sm:p-8"
            >
              <div className="flex items-start gap-4">
                <div className="shrink-0">{b.icon}</div>
                <p className="text-[15px] sm:text-[16px] leading-relaxed text-[#111827] font-medium">
                  {b.title}
                </p>
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  )
}

/* -------------------------------------------
   SECTION 3 — HOW WE COVER NCERT ECONOMY
   Step-by-step horizontal flow/journey
-------------------------------------------- */

function HowWeCoverNcertSection() {
  const steps = [
    {
      num: "1",
      title: "Watch",
      desc: "Free NCERT Economy lectures on YouTube (Class 9–12)",
    },
    {
      num: "2",
      title: "Capture",
      desc: "Key ideas through guided NCERT worksheets",
    },
    {
      num: "3",
      title: "Revise & Check",
      desc: "Reinforce concepts using NCERT-based MCQs",
    },
  ]

  return (
    <section className="bg-white py-14 sm:py-16">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center max-w-3xl mx-auto">
          <h2 className="text-3xl sm:text-4xl font-semibold text-[#111827]">
            How We Cover NCERT Economy
          </h2>
        </div>

        {/* Flow: stacked on mobile, horizontal on desktop */}
        <div className="mt-10">
          <div className="grid grid-cols-1 md:grid-cols-3 gap-6 lg:gap-8">
            {steps.map((s) => (
              <div
                key={s.num}
                className="h-full bg-white rounded-2xl border border-gray-200 shadow-[0_10px_30px_rgba(0,0,0,0.06)] p-7 sm:p-8"
              >
                <div className="flex items-start gap-4">
                  <div className="shrink-0">
                    <div className="h-10 w-10 rounded-full bg-blue-600 text-white flex items-center justify-center font-semibold shadow-sm">
                      {s.num}
                    </div>
                  </div>
                  <div>
                    <h3 className="text-xl sm:text-2xl font-semibold text-[#111827]">
                      {s.title}
                    </h3>
                    <p className="mt-2 text-[15px] sm:text-[16px] leading-relaxed text-[#4B5563]">
                      {s.desc}
                    </p>
                  </div>
                </div>
              </div>
            ))}
          </div>

          {/* calm reassurance line (no pricing/CTA here) */}
          <p className="mt-6 text-center text-sm sm:text-base text-[#6B7280]">
            A methodical, calm journey — so you always know what to do next.
          </p>
        </div>
      </div>
    </section>
  )
}

/* -------------------------------------------
   OPTION A ADD-ON — NCERT BOOK DOWNLOADS
   Placeholder data; user will replace with real inputs
-------------------------------------------- */

type NcertBook = {
  id: string
  title: string
  subtitle?: string
  coverSrc: string
  downloadHref: string
}

const DUMMY_BOOKS: NcertBook[] = [
  {
    id: "c9-econ",
    title: "NCERT Economics — Class 9",
    subtitle: "Dummy Book Title",
    coverSrc: "/class_9_economics.jpg",
    downloadHref: "https://ncert.nic.in/textbook/pdf/iess2dd.zip",
  },
  {
    id: "c10-econ",
    title: "NCERT Economics — Class 10",
    subtitle: "Understanding Economic Development",
    coverSrc: "/class_10_economics.jpg",
    downloadHref: "https://ncert.nic.in/textbook/pdf/jess2dd.zip",
  },
  {
    id: "c11-ied",
    title: "NCERT Economics — Class 11",
    subtitle: "Indian Economic Development",
    coverSrc: "/class_11_economics_1.jpg",
    downloadHref: "https://ncert.nic.in/textbook/pdf/keec1dd.zip",
  },
  {
    id: "c11-ied2",
    title: "NCERT Economics — Class 11",
    subtitle: "Statistics for Economics",
    coverSrc: "/class_11_economics_2.jpg",
    downloadHref: "https://ncert.nic.in/textbook/pdf/kest1dd.zip",
  },
  {
    id: "c12-micro",
    title: "NCERT Economics — Class 12",
    subtitle: "Introduction to Microeconomics",
    coverSrc: "/class_12_economics_1.jpg",
    downloadHref: "https://ncert.nic.in/textbook/pdf/leec2dd.zip",
  },
  {
    id: "c12-macro2",
    title: "NCERT Economics — Class 12",
    subtitle: "Introduction to Macroeconomics",
    coverSrc: "/class_12_economics_2.jpg",
    downloadHref: "https://ncert.nic.in/textbook/pdf/leec1dd.zip",
  },
]

function NcertBooksDownloadSection() {
  const books = DUMMY_BOOKS // ✅ Replace this array with your real book inputs

  return (
    <section id="ncert-downloads" className="bg-white py-14 sm:py-16 scroll-mt-24">
      <div className="max-w-7xl mx-auto px-5 sm:px-6 lg:px-8">
        <div className="text-center max-w-3xl mx-auto">
          <h2 className="text-3xl sm:text-4xl font-semibold text-[#111827]">
            Download NCERT Economics Books (Class 9–12)
          </h2>
          <p className="mt-3 sm:mt-4 text-base sm:text-lg text-[#4B5563] leading-relaxed">
            Grab the books directly from here — and use them alongside the course so
            your reading stays structured and exam-focused.
          </p>
        </div>

        {/* Horizontal strip (desktop + mobile) */}
        <div className="mt-10 sm:mt-12 -mx-5 px-5 overflow-x-auto">
          <div className="flex gap-5 sm:gap-6">
            {books.map((b) => (
              <div key={b.id} className="flex-shrink-0 w-52 sm:w-56">
                <div className="h-full bg-white rounded-2xl border border-gray-200 shadow-[0_10px_30px_rgba(0,0,0,0.06)] overflow-hidden flex flex-col">
                  <div className="relative w-full aspect-[3/4] bg-[#F9FAFB]">
                    <Image
                      src={b.coverSrc}
                      alt={b.title}
                      fill
                      className="object-cover"
                      sizes="(max-width: 640px) 208px, 224px"
                    />
                  </div>

                  <div className="p-4 flex flex-col gap-2 flex-1">
                    <div>
                      <p className="text-[15px] sm:text-base font-semibold text-[#111827] leading-snug line-clamp-2">
                        {b.title}
                      </p>
                      {b.subtitle && (
                        <p className="mt-1 text-sm text-[#6B7280] leading-snug line-clamp-2">
                          {b.subtitle}
                        </p>
                      )}
                    </div>

                    <div className="mt-auto pt-2">
                      <a
                        href={b.downloadHref}
                        target={b.downloadHref.startsWith("http") ? "_blank" : undefined}
                        rel={
                          b.downloadHref.startsWith("http")
                            ? "noopener noreferrer"
                            : undefined
                        }
                        className={`items-center justify-center w-full px-4 py-2.5 rounded-full text-sm font-semibold bg-blue-600 hover:bg-blue-700 text-white transition-colors group ${HOVER_ANIM}`}
                      >
                        Download
                        <span className="ml-2 transition-transform duration-200 group-hover:translate-x-1">
                          →
                        </span>
                      </a>
                    </div>
                  </div>
                </div>
              </div>
            ))}
          </div>
        </div>

        <div className="mt-6 text-center text-sm text-[#6B7280]">
          Tip: On mobile, swipe to view all books.
        </div>
      </div>
    </section>
  )
}

/* -------------------------------------------
   SECTION 4 — NCERT ECONOMY WORKSHEETS & PRACTICE PACK
   Content locked — do not modify
-------------------------------------------- */

function WorksheetsPackSection() {
  return (
    <section className="bg-white py-16 sm:py-20">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="flex flex-col lg:flex-row items-start gap-10 lg:gap-16">
          {/* Left: Text */}
          <div className="w-full lg:w-7/12">
            <h2 className="text-3xl sm:text-4xl font-semibold text-[#111827]">
              NCERT Economy Worksheets &amp; Practice Pack
            </h2>

            <p className="mt-4 text-base sm:text-lg text-[#4B5563] leading-relaxed max-w-2xl">
              This pack helps you work through NCERT Economics actively, instead of just
              reading or watching videos.
            </p>

            <p className="mt-2 text-base sm:text-lg text-[#4B5563] leading-relaxed max-w-2xl">
              It is meant to convert:
            </p>

            <ul className="mt-3 space-y-2 text-[15px] sm:text-[16px] text-[#374151]">
              <li className="flex gap-2">
                <span className="mt-[6px] text-sm">•</span>
                <span>NCERT reading</span>
              </li>
              <li className="flex gap-2">
                <span className="mt-[6px] text-sm">•</span>
                <span>YouTube explanations</span>
              </li>
            </ul>

            <p className="mt-3 text-base sm:text-lg text-[#4B5563] leading-relaxed max-w-2xl">
              into written understanding and tested clarity.
            </p>

            <div className="mt-8">
              <h3 className="text-lg sm:text-xl font-semibold text-[#111827]">
                What this pack helps you do
              </h3>
              <ul className="mt-4 space-y-2 text-[15px] sm:text-[16px] text-[#374151]">
                <li className="flex gap-2">
                  <span className="mt-[6px] text-sm">•</span>
                  <span>Work through NCERT chapters using structured worksheets</span>
                </li>
                <li className="flex gap-2">
                  <span className="mt-[6px] text-sm">•</span>
                  <span>Revise NCERT Economics systematically</span>
                </li>
                <li className="flex gap-2">
                  <span className="mt-[6px] text-sm">•</span>
                  <span>Check your understanding using NCERT-based MCQs</span>
                </li>
              </ul>
            </div>

            <div className="mt-8">
              <h3 className="text-lg sm:text-xl font-semibold text-[#111827]">
                What you get
              </h3>
              <ul className="mt-4 space-y-2 text-[15px] sm:text-[16px] text-[#374151]">
                <li className="flex gap-2">
                  <span className="mt-[6px] text-sm">•</span>
                  <span>
                    <span className="font-semibold">NCERT Economy Worksheets</span>{" "}
                    (chapter-wise, guided, aligned with Class 9–12 NCERTs)
                  </span>
                </li>
                <li className="flex gap-2">
                  <span className="mt-[6px] text-sm">•</span>
                  <span>
                    <span className="font-semibold">200+ NCERT-based MCQs</span>{" "}
                    (Level 1 and Level 2)
                  </span>
                </li>
              </ul>
            </div>

            <p className="mt-6 text-base sm:text-lg text-[#4B5563] leading-relaxed max-w-2xl">
              Once you complete the worksheets and MCQs, NCERT Economics is no longer a
              loose or half-done part of your preparation.
            </p>

            <p className="mt-6 text-lg sm:text-xl font-semibold text-[#111827]">
              ₹199 — one-time access
            </p>

            <div className="mt-6">
              <Link
                href="/pay/ncert-pack" // TODO: update to actual purchase route
                className={`items-center justify-center px-7 py-3.5 rounded-lg text-sm sm:text-base font-semibold text-white ${PRIMARY_BLUE} transition-colors w-full sm:w-auto sm:min-w-[320px] ${HOVER_ANIM}`}
              >
                Get NCERT Economy Worksheets &amp; Practice Pack
              </Link>
            </div>
          </div>

          {/* Right: Visual emphasis area */}
          <div className="w-full lg:w-5/12">
            <div className="bg-white rounded-2xl border border-gray-200 shadow-[0_10px_30px_rgba(0,0,0,0.06)] p-7 sm:p-8">
              <p className="text-sm font-semibold text-[#111827]">
                Worksheets
              </p>

              <div className="mt-4 rounded-xl bg-[#F9FAFB] border border-gray-100 overflow-hidden">
                <Image
                  src="/Nankinomics- Notes cum worksheet 1 (1)-1.png" // TODO: replace with your image
                  alt="NCERT Economy Worksheets Preview"
                  width={600}
                  height={360}
                  className="w-full h-auto object-cover"
                />
              </div>

              <p className="mt-6 text-sm font-semibold text-[#111827]">MCQs</p>
              <div className="mt-4 rounded-xl bg-[#F9FAFB] border border-gray-100 overflow-hidden">
                <Image
                  src="/mcq_pic.jpg" // TODO: replace with your image
                  alt="NCERT Economy Worksheets Preview"
                  width={600}
                  height={360}
                  className="w-full h-auto object-cover"
                />
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}

/* -------------------------------------------
   Small inline icons for Section 2 (simple + clean)
-------------------------------------------- */

function ConceptIcon() {
  return (
    <div className="h-12 w-12 rounded-2xl bg-blue-50 flex items-center justify-center border border-blue-100">
      <svg viewBox="0 0 24 24" className="h-6 w-6 text-blue-600" fill="none" stroke="currentColor" strokeWidth="2">
        <path d="M12 3l9 5-9 5-9-5 9-5Z" />
        <path d="M3 8v8l9 5 9-5V8" />
      </svg>
    </div>
  )
}

function ExamIcon() {
  return (
    <div className="h-12 w-12 rounded-2xl bg-blue-50 flex items-center justify-center border border-blue-100">
      <svg viewBox="0 0 24 24" className="h-6 w-6 text-blue-600" fill="none" stroke="currentColor" strokeWidth="2">
        <path d="M7 3h10a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2Z" />
        <path d="M9 8h6M9 12h6M9 16h4" />
      </svg>
    </div>
  )
}

function ApplicationIcon() {
  return (
    <div className="h-12 w-12 rounded-2xl bg-blue-50 flex items-center justify-center border border-blue-100">
      <svg viewBox="0 0 24 24" className="h-6 w-6 text-blue-600" fill="none" stroke="currentColor" strokeWidth="2">
        <path d="M4 19V5a2 2 0 0 1 2-2h9l5 5v11a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2Z" />
        <path d="M14 3v5h5" />
        <path d="M8 14h8M8 17h6" />
      </svg>
    </div>
  )
}

function Section6_FAQs_ncert() {
  type FAQItem = {
    question: string;
    answer: React.ReactNode;
  };

  const FAQ_ITEMS: FAQItem[] = [
    {
      question: "Who is this NCERT Economics course meant for?",
      answer: (
        <>
          This course is for anyone who wants to understand Economics from the
          basics before jumping into heavier UPSC material. It’s ideal for
          beginners, college students, self-study learners, aspirants who find
          Economy difficult, and those who feel overwhelmed in long 120–160 hour
          Foundation courses. It acts as a bridge between starting from zero and
          studying advanced content confidently.
        </>
      ),
    },
    {
      question:
        "Do I need to finish all five NCERTs (Class 9–12, including Class 12 Micro & Macro)?",
      answer: (
        <>
          No. You don’t need to complete all five books end-to-end. Almost every
          NCERT chapter has something relevant, but not all carry equal weight.
          This course shows what to read fully, what to read selectively, and what
          can be skimmed, so you study what matters — not everything blindly.
        </>
      ),
    },
    {
      question: "Is NCERT enough for UPSC Economics?",
      answer: (
        <>
          NCERT builds your fundamentals, but for UPSC you will still need current
          affairs, Economic Survey & Budget, and applied understanding of policies
          and data. This course ensures your basics become strong, so advanced
          sources become easier and far more meaningful.
        </>
      ),
    },
    {
      question: "How long does this course take to finish?",
      answer: (
        <>
          The complete video set is about 20 hours. Most learners finish it in
          7–10 days, while some take 2–3 weeks depending on their pace.
        </>
      ),
    },
    {
      question: "What language is the course in?",
      answer: (
        <>
          Videos are in Hinglish — mainly English with simple Hindi explanations
          where needed. Worksheets are in English.
        </>
      ),
    },
    {
      question: "What teaching method do you follow?",
      answer: (
        <div className="space-y-2">
          <p>A simple 3-step system:</p>
          <ul className="list-disc pl-5 space-y-1">
            <li>Watch → short conceptual videos</li>
            <li>Write → guided worksheets</li>
            <li>Practice → MCQs and short tests</li>
          </ul>
          <p>
            This helps you understand and retain concepts, not just cover the
            books.
          </p>
        </div>
      ),
    },
    {
      question: "What do I get with the Full Access Plan (₹199)?",
      answer: (
        <div className="space-y-2">
          <p>You receive the complete NCERT toolkit:</p>
          <ul className="list-disc pl-5 space-y-1">
            <li>Worksheets (delivered via email)</li>
            <li>200 NCERT-based MCQs</li>
            <li>2 Doubt-Clearing Sessions</li>
            <li>Private Telegram Community access</li>
          </ul>
        </div>
      ),
    },
    {
      question:
        "Why should I buy the paid plan when videos are free on YouTube?",
      answer: (
        <>
          Videos explain the concepts. The paid plan gives you the full system:
          worksheets (active recall), MCQs (testing), doubt support, and a
          structured learning path that makes your preparation exam-ready.
        </>
      ),
    },
    {
      question: "I’m starting preparation late. Will this still help me?",
      answer: (
        <>
          Yes. This is a high-ROI, low-time foundation course. You can finish your
          NCERT basics in 20 hours and build confidence quickly.
        </>
      ),
    },
  ];

  return (
    <section className="bg-white py-16 sm:py-20 border-t border-gray-100">
      <div className="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
        <h2 className="text-3xl sm:text-4xl font-semibold text-[#111827] text-center">
          FAQs — NCERT Economy course
        </h2>

        <div className="mt-10 space-y-4">
          {FAQ_ITEMS.map((f, i) => (
            <details
              key={i}
              className="group bg-white rounded-2xl border border-gray-200 shadow-[0_10px_30px_rgba(0,0,0,0.06)] p-6 sm:p-7"
            >
              <summary className={`cursor-pointer list-none flex items-start justify-between gap-4 ${HOVER_ANIM}`}>
                <span className="text-[15px] sm:text-[16px] font-semibold text-[#111827] leading-relaxed">
                  {f.question}
                </span>
                <span className="mt-1 text-[#6B7280] transition-transform duration-200 group-open:rotate-180">
                  ▾
                </span>
              </summary>

              <div className="mt-4 text-[15px] sm:text-[16px] text-[#4B5563] leading-relaxed">
                {f.answer}
              </div>

            </details>
          ))}
        </div>

        {/* No extra CTAs required by spec; keeping it clean */}
      </div>
    </section>
  )
}
